/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.CoordMath;
import java.util.Objects;

public interface Locatable {
    public String getContig();

    public int getStart();

    public int getEnd();

    default public int getLengthOnReference() {
        return CoordMath.getLength(this.getStart(), this.getEnd());
    }

    default public boolean overlaps(Locatable other) {
        return this.withinDistanceOf(other, 0);
    }

    default public boolean withinDistanceOf(Locatable other, int distance) {
        return this.contigsMatch(other) && CoordMath.overlaps(this.getStart(), this.getEnd(), other.getStart() - distance, other.getEnd() + distance);
    }

    default public boolean contains(Locatable other) {
        return this.contigsMatch(other) && CoordMath.encloses(this.getStart(), this.getEnd(), other.getStart(), other.getEnd());
    }

    default public boolean contigsMatch(Locatable other) {
        return this.getContig() != null && other != null && Objects.equals(this.getContig(), other.getContig());
    }
}

