/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;

public class InstantiationClassMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
ClassVisitor {
    private final OptimizationInfoClassFilter filteredClassMarker = new OptimizationInfoClassFilter(this);

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -69) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this.filteredClassMarker);
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        InstantiationClassMarker.setInstantiated(clazz);
    }

    private static void setInstantiated(Clazz clazz) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setInstantiated();
    }

    public static boolean isInstantiated(Clazz clazz) {
        return ClassOptimizationInfo.getClassOptimizationInfo(clazz).isInstantiated();
    }
}

