/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import java.util.Arrays;

class ReferenceRegion {
    private final int index;
    private final String name;
    private long alignmentStart;
    private int arrayStart;
    private final byte[] array;

    public ReferenceRegion(byte[] bases, int sequenceIndex, String sequenceName, long alignmentStart, long alignmentEnd) {
        this.array = bases;
        this.index = sequenceIndex;
        this.name = sequenceName;
        if (alignmentEnd == -1L) {
            alignmentEnd = bases.length;
        }
        if (alignmentStart < 1L || alignmentEnd < alignmentStart || alignmentEnd - alignmentStart > (long)bases.length || alignmentEnd - 1L > (long)bases.length) {
            throw new IllegalArgumentException(String.format("Invalid reference region: %s, %d, %d.", sequenceName, alignmentStart, alignmentEnd));
        }
        this.alignmentStart = alignmentStart;
        this.arrayStart = (int)(alignmentStart - 1L);
    }

    int arrayPosition(long alignmentPosition) {
        int arrayPosition = (int)((long)this.arrayStart + (alignmentPosition - this.alignmentStart));
        if (arrayPosition < 0 || arrayPosition > this.array.length) {
            throw new IllegalArgumentException("The alignment position is out of the region: " + alignmentPosition);
        }
        return arrayPosition;
    }

    public byte base(long alignmentPosition) {
        return this.array[this.arrayPosition(alignmentPosition)];
    }

    public byte[] copy(long alignmentStart, int alignmentSpan) {
        int from = this.arrayPosition(alignmentStart);
        int to = this.arrayPosition(alignmentStart + (long)alignmentSpan);
        return Arrays.copyOfRange(this.array, from, to);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public long getAlignmentStart() {
        return this.alignmentStart;
    }
}

