/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class MultiThreadedErrorTracker {
    private RuntimeException error = null;

    public synchronized void throwErrorIfPending() {
        if (this.hasAnErrorOccurred()) {
            throw this.getError();
        }
    }

    public synchronized boolean hasAnErrorOccurred() {
        return this.error != null;
    }

    public synchronized RuntimeException getError() {
        if (!this.hasAnErrorOccurred()) {
            throw new ReviewedStingException("User has attempted to retrieve a traversal error when none exists");
        }
        return this.error;
    }

    public synchronized RuntimeException notifyOfError(Throwable error) {
        if (this.error == null) {
            this.error = this.toRuntimeException(error);
        }
        return this.error;
    }

    private RuntimeException toRuntimeException(Throwable error) {
        if (error instanceof RuntimeException) {
            return (RuntimeException)error;
        }
        return new ReviewedStingException("An error occurred during the traversal.  Message=" + error.getMessage(), error);
    }
}

